package qa.configureproject;
import org.testng.TestNG;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ConfigureEnv {
    //Récupération des informations des outils comme Java, Maven, TestNG
    public static void getToolsInfo() {
        try {
            //Message de félicitations
            System.out.println("\nFélicitation, vous avez bien configuré l'environnement de votre projet. \nVoici les informations des outils installés");
            // Obtenir la version actuelle de Java
            String javaVersion = System.getProperty("java.version");
            System.out.println("Version de Java : " + javaVersion);

            // Obtenir la version actuelle de TestNG
            String testNGVersion = TestNG.class.getPackage().getImplementationVersion();
            System.out.println("Version de TestNG : " + testNGVersion);
        } catch (Exception e) {
            System.err.println("Erreur lors de la récupération des versions : " + e.getMessage());
        }
    }

    private static String getCommandOutput(String command) throws IOException {
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder output = new StringBuilder();
        String line;
        while ((line = reader.readLine()) != null) {
            output.append(line).append("\n");
        }
        return output.toString().trim();
    }
}