# selenium-express---config-validation
# Projet de Tests Automatisés avec TestNG et Maven

## Description

Ce projet est une suite de tests automatisés développée en Java, utilisant le framework **TestNG** pour l'exécution des tests et **Maven** pour la gestion des dépendances et du cycle de vie du projet. Il est conçu pour valider les connaissances aquises pour la configuration d'un projet Selenium WebDriver.

Les rapports de test sont générés automatiquement et disponibles dans le répertoire `target/surefire-reports` au format HTML, XML, et autres.

## Structure du Projet

- **`src/main/java/qa/`** : Contient le code source principal (si applicable).
- **`src/test/java/qa/`** : Contient les classes de tests automatisés.
- **`testng.xml`** : Fichier de configuration TestNG pour définir les suites de tests, les groupes, et les paramètres.
- **`pom.xml`** : Fichier de configuration Maven pour gérer les dépendances et les plugins.
- **`target/`** : Répertoire généré par Maven contenant les classes compilées, les rapports de test, et d'autres fichiers temporaires.

## Prérequis

Avant d'exécuter ce projet, assurez-vous d'avoir installé les outils suivants :

1. **Java Development Kit (JDK)** : Version 17 ou supérieure.
2. **Apache Maven** : Version 3.6 ou supérieure.
3. **Un IDE** (comme IntelliJ IDEA ou Eclipse) ou un éditeur de texte comme Visual Studio Code.

## Installation

1. Clonez ce dépôt sur votre machine locale :
```bash
    git clone https://github.com/demos-formations-Qalilab-Academy/selenium-express---config-validation.git
    cd selenium-express---config-validation
```

2. Installez les dépendances Maven: 
```bash
    mvn clean install -f "pom.xml"
```

## Exécution des Tests
1. Exécution via Maven
Pour exécuter tous les tests définis dans testng.xml, utilisez la commande suivante : 
```bash 
    mvn test -f "pom.xml"
```

2. Exécution via IDE
    1. Importez le projet dans votre IDE.
    2. Localisez le fichier testng.xml.
    3. Faites un clic droit sur le fichier et sélectionnez *Run testng.xml*.

3. Rapports de Test
Après l'exécution des tests, les rapports sont générés dans le répertoire suivant : *target/surefire-reports/*

Vous pouvez ouvrir le fichier index.html dans un navigateur pour consulter les résultats des tests sous forme de rapport.

# Licence
Ce projet est sous licence MIT.

# Auteurs
Développé par l'équipe QA responsable de la formation chez **Qalilab Academy**.

