package com.qalilab.Exemple;

import com.qalilab.Config.WebDriverManager;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.junit.Test;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

import java.time.Duration;
import java.util.List;

/**
 * ❌ MAUVAIS EXEMPLE - Code Spaghetti
 * Difficile à maintenir, réutiliser, et comprendre
 */
public class SpaghettiCodeExemple {

    @Test
    public void testSpaghettiCode_FullWorkflow() {
        // ❌ Duplication massive + chaos technique
        WebDriver driver = new ChromeDriver();
        driver.manage().window().maximize();
        WebDriverWait wait = new WebDriverWait(driver, Duration.ofSeconds(10));
        driver.get("https://www.saucedemo.com");

        // ❌ 10 lignes pour un simple login !
        WebElement username = driver.findElement(By.id("user-name"));
        username.clear();
        username.sendKeys("standard_user");
        WebElement password = driver.findElement(By.id("password"));
        password.clear();
        password.sendKeys("secret_sauce");
        WebElement loginBtn = driver.findElement(By.id("login-button"));
        loginBtn.click();

        // ❌ Attentes primitives
        try { Thread.sleep(3000); } catch(Exception e) {}

        // ❌ Logique métier noyée dans le technique
        List<WebElement> products = driver.findElements(By.className("inventory_item"));
        if(products.size() > 0) {
            WebElement addBtn = driver.findElement(
                    By.cssSelector("button[data-test='add-to-cart-sauce-labs-backpack']"));
            addBtn.click();

            try { Thread.sleep(1000); } catch(Exception e) {}

            // ❌ Vérifications hardcodées dispersées
            WebElement cartBadge = driver.findElement(By.className("shopping_cart_badge"));
            if(cartBadge.getText().equals("1")) {
                WebElement cartLink = driver.findElement(By.className("shopping_cart_link"));
                cartLink.click();

                try { Thread.sleep(2000); } catch(Exception e) {}

                WebElement checkoutBtn = driver.findElement(By.id("checkout"));
                checkoutBtn.click();

                try { Thread.sleep(1500); } catch(Exception e) {}

                // ❌ Plus de hardcoding sans fin
                WebElement firstName = driver.findElement(By.id("first-name"));
                firstName.clear();
                firstName.sendKeys("John");
                WebElement lastName = driver.findElement(By.id("last-name"));
                lastName.clear();
                lastName.sendKeys("Doe");
                WebElement postalCode = driver.findElement(By.id("postal-code"));
                postalCode.clear();
                postalCode.sendKeys("12345");

                WebElement continueBtn = driver.findElement(By.id("continue"));
                continueBtn.click();

                try { Thread.sleep(2000); } catch(Exception e) {}

                WebElement finishBtn = driver.findElement(By.id("finish"));
                finishBtn.click();

                try { Thread.sleep(3000); } catch(Exception e) {}

                // ❌ Assertion perdue dans le chaos
                WebElement confirmation = driver.findElement(By.className("complete-header"));
                assert confirmation.getText().equals("Thank you for your order!");
            }
        }
        driver.quit();
        // 47 LIGNES DE CAUCHEMAR ! 😱
    }

    @Test
    public void testSpaghettiCode_SameFeature() {
        // Code non structuré, tout mélangé
        WebDriver driver = WebDriverManager.getDriver();
        driver.get("https://www.saucedemo.com");

        // Locators dispersés dans le code
        driver.findElement(By.id("user-name")).sendKeys("standard_user");
        driver.findElement(By.id("password")).sendKeys("secret_sauce");
        driver.findElement(By.id("login-button")).click();

        // Logique métier mélangée avec les actions techniques
        if(!driver.findElements(By.className("inventory_item")).isEmpty()) {
            driver.findElement(By.cssSelector("button[data-test^='add-to-cart']")).click();

            // Vérifications hardcodées
            String cartCount = driver.findElement(By.className("shopping_cart_badge")).getText();
            if(cartCount.equals("1")) {
                driver.findElement(By.className("shopping_cart_link")).click();
                driver.findElement(By.id("checkout")).click();

                // Encore plus de code technique mélangé
                driver.findElement(By.id("first-name")).sendKeys("John");
                driver.findElement(By.id("last-name")).sendKeys("Doe");
                driver.findElement(By.id("postal-code")).sendKeys("12345");
                driver.findElement(By.id("continue")).click();
                driver.findElement(By.id("finish")).click();

                // Test assertion perdue dans le code
                String confirmation = driver.findElement(By.className("complete-header")).getText();
                assert confirmation.equals("Thank you for your order!");
            }

        }
        // ❌ Problèmes de ce code:
        // 1. Pas de réutilisabilité
        // 2. Difficile à maintenir
        // 3. Locators dispersés
        // 4. Logique métier mélangée
        // 5. Impossible à déboguer facilement
        // 6. Pas de structure claire
    }
    @Test
    public void testSpaghettiCode_DuplicatedLogin() {
        // ❌ MÊME CODE DE LOGIN DUPLIQUÉ - Démonstration du problème
        WebDriver driver = new ChromeDriver();
        driver.get("https://www.saucedemo.com");
        driver.findElement(By.id("user-name")).sendKeys("standard_user");
        driver.findElement(By.id("password")).sendKeys("secret_sauce");
        driver.findElement(By.id("login-button")).click();

        // Test spécifique ici...
        driver.quit();
        // ❌ 10 lignes de duplication pour chaque test !
    }




}